;;####################################################################
;; logoobj2.lsp 
;; Copyright (c) 1998-2000 by Forrest W. Young
;; Creates a window containing the dynamic vista logo.
;;####################################################################




(defun do-logo (&key (pause 60) (number nil) (msg-number 100) (copyright t) 
                          (location nil) (size '(440 220))
                          (animate-margin nil) (margin t))
  (setf *logo* 
    (display-logo :pause pause :number number :msg-number msg-number 
                  :copyright copyright :location location :size size 
                  :margin margin))
  (pause pause)
  (disolve-splash-screen *logo*))

(defun display-logo (&key (number nil) (msg-number 100) (copyright nil) 
                          (location nil) (size '(440 220)) (pause 0)
                          (animate-margin nil) (margin t))
  (let ((real-run-number *run-number*)
        )
;(break)
    (when number (setf *run-number* number))
    (setf *last-text* 30)
    (setf *real-screen-size* (screen-size))
    (setf *68040* t)
    ;(when *initial-install* (setf *show-flying-logo* t))
    (setf *logo* 
          (start-splash-screen :message-number msg-number
                               :size size :location location
                               :show t :free t :margin margin
                               :copyright copyright
                               :animate-margin animate-margin));*show-flying-logo* 

    (setf *run-number* real-run-number)
    (defmeth *logo* :close ())
    
    (send *logo* :redraw)
    (when pause (pause pause))
    (when *verbose* (format t "; splash screen started"))

    (when (and *pro-version* (< *run-number* 2))
          (send *logo* :set-no-animation))
    (when (and (not *frames-per-second*) *show-flying-logo*)
	(one-button-dialog "logoobj2 - calculating frames-per-second")
          (cond
            ((or (not *frames-per-second*)(< *frames-per-second* 1) )
             (setf *frames-per-second* (send *logo* :get-frames-per-second))) 
            ((< 0 *run-number* 5)
             (setf *frames-per-second*
                   (round (/ (+ (* *run-number* *frames-per-second*)
                                (send *logo* :get-frames-per-second)) 
                             (1+ *run-number*))))
             ))
          (send logo-proto :frames-per-second *frames-per-second*)
          (send *logo* :frames-per-second *frames-per-second*)
          (when *verbose* (format t "~%; frames-per-second ~d" *frames-per-second*)))
    (send *logo* :redraw)
    (when copyright (send *logo* :copyright 15 nil))
    *logo*
    ))


;(setf a (ceiling (+ 3 (* 20 (uniform-rand 100)))))

(defun start-splash-screen 
  (&key (draw-color 'yellow) (back-color 'black) (show t) 
        (location nil) (size '(440 220)) (margin nil) (copyright nil)
        (animate-margin nil)
        (message-number (first (floor (+ 3 (* 20 (uniform-rand 1))))))
        )
  (let* ((w (start-logo-screen :message-number message-number
                               :show show :size size :location location
                               :margin margin :animate-margin animate-margin 
                               :draw-color draw-color 
                               :back-color back-color)))
    (defmeth w :random-message ()
      (let ((msg-num (first (floor (+ 3 (* 20 (uniform-rand 1))))))
            (nscreens 24))
        (send self :nclicks msg-num)
        (when (< msg-num nscreens)
              (send self :show-text msg-num))))
    (defmeth w :message (i)
      (let ((nscreens 24))
        (send self :nclicks i)
        (when (< i nscreens)
              (send self :show-text i))))
    (send w :animate-margin :animate animate-margin)
    (send w :splash-screen-idle)
    w))

(defun start-logo-screen 
  (&key (message-number (first (floor (+ 3 (* 20 (uniform-rand 1))))))
        (show t) (size '(440 220)) (location nil) 
        (animate-margin nil) (margin nil)
        (draw-color 'black) (back-color 'white))  
  (let* ((w (make-logo :copyright-at-top t :free t :local-menus t 
               :draw-color draw-color :back-color back-color
               :size (list 40 20) :show nil
               :type 0 :pop-out t :message-number message-number))
         (loc (send w :location)))

    (send w :magic-show size show margin animate-margin)
    ;(send w :magic-show size message-number show margin w animate-margin)
    ;(send w :redraw)
    w))



(defmeth logo-proto :clear-buffers ()
  (send self :buffer (list nil nil nil nil nil nil nil)))

(defmeth logo-proto :write-text 
          (text &optional locx locy (p 1) (q 1) (bufnum 0))
  (let* ((text-size (+ 1 (send self :text-ascent) (send self :text-descent)))
         (loc (if locx (list locx locy)
                  (+ (send self :real-to-canvas 15 -1)
                     (* 3 (list 0 text-size)))))

         ;(prev-text (send self :prev-text))
         (buffer (send self :buffer))
         (prev-text (select buffer bufnum))
         (back-color (send self :back-color-default))
         (draw-color (send self :draw-color-default)))
    (when prev-text
          (send self :draw-color back-color)
          (send self :draw-text prev-text (first loc) (second loc) p q)
          (send self :draw-color draw-color))
    (when text
          (send self :draw-text text (first loc) (second loc) p q)
          (setf (select buffer bufnum) text)
          (send self :buffer buffer)
          (send self :draw-color draw-color))
    loc))

(defmeth logo-proto :apply-transformation (&rest args)
  (let ((ok) (result))
    (setf ok (ignore-errors (setf result (apply #'call-next-method args)) t))
    (when (and *v* (not ok)) (format t "; ignoring apply-transformation error~%"))
    nil))

(defmeth logo-proto :random-rotate (&optional (a 10))
  (let* ((m (send self :transf))
         (count (send self :count))
         (fpr (send self :frames-per-rotation))
         )
    (when (not fpr) (setf fpr 200))
    (when (not count) (setf count 0))
   (when (> count fpr);720
                 (send self :new-shape)
                 (setf count 0)
                 (send self :transformation nil)
         )
    (send self :count (1+ count))
    (send self :apply-transformation m)
    t))


;===================
;about vista
;===================


(defmeth logo-proto :do-key (c m1 m2)
  (send self :next-message))

(defmeth logo-proto :next-message (&key (repeat nil))
  (let ((nclicks (send self :nclicks))
        (nscreens 25))
    (setf nclicks (1+ nclicks))
    (when (and (= nclicks nscreens) repeat) (setf nclicks 0))
    (send self :nclicks nclicks)
    (cond 
      ((< nclicks nscreens)
       (send self :show-text nclicks))
      ((= nclicks nscreens)
       (send self :fade-splash-screen)
       (send self :clear-splash-screen)
       (send self :remove)))))



(defmeth logo-proto :do-click (x y m1 m2)
  (send self :do-key "a" m1 m2))

(defmeth logo-proto :animation (&optional (arg nil used?))
  (if used? (animation arg) (animation)))


(defun animation (&optional (arg nil used?))
"Retrieves the value of the *animation* variable when ARG is not used; sets *animation* to ARG when ARG is used. Also sets the variables *show-zooming-desktop*, *show-flying-logo*, and *show-flying-exit-logo* to the value of arg when ARG is used."
  (when used? 
        (setf *animation* arg)
        (setf *show-flying-logo* arg)
        (setf *show-zooming-desktop* arg)
        (setf *show-flying-exit-logo* arg))
  *animation*)

(defmeth logo-proto :set-no-animation ()
  (animation nil))

(defmeth logo-proto :animation? ()
  (or *show-flying-logo* *show-zooming-desktop* *show-flying-exit-logo*))

(defun animation? ()
  (or *show-flying-logo* *show-zooming-desktop* *show-flying-exit-logo*))

(setf *animation* (animation?))

(defmeth logo-proto :animate-margins (&key (animate *animation*))
  (send self :animate-margin :animate animate))

(defmeth logo-proto :animate-margin (&key (animate *animation*))
"Animates the margins of the logo window. Default value is the value of *animation*"
  (let* ((fps (send self :frames-per-second))
         (text-size (+ 1 (send self :text-ascent) (send self :text-descent)))
         (nlines-top 3)
         (nlines-bot 4)
         (size (send self :size))
         (aspect-ratio (/ (first size) (second size)))
         (sidelines (/ (+ nlines-top nlines-bot) (+ 2 aspect-ratio)))
         )
    (if animate
        (when (not fps) 
              (setf fps *frames-per-second*)
              (unless fps (setf fps 40))
              (send  logo-proto :frames-per-second *frames-per-second*))
        (setf fps 0))
;(print "animate margins, here in logoobj2")
;(openmainwindow)(break)
    (cond
      ((> 2 fps)
       (apply #'send self :margin (round (* text-size (list sidelines nlines-top 
             sidelines nlines-bot))))
       (send self :simple-write)
       )
      (t
       (setf fps (ceiling (/ fps 3)))
       (dolist (i (if (> 2 fps) (list text-size) (rseq 1 text-size fps)))
               (send self :margin 
                     (round (* sidelines i))
                     (round (* nlines-top i)) 
                     (round (* sidelines i))
                     (round (* nlines-bot i)))
               (send self :simple-write)))))
      t)

(defmeth logo-proto :set-margin ()
  (let* ((text-size (+ 1 (send self :text-ascent) (send self :text-descent)))
         (nlines-top 3)
         (nlines-bot 4)
         (size (send self :size))
         (aspect-ratio (/ (first size) (second size)))
         (sidelines (/ (+ nlines-top nlines-bot) (+ 2 aspect-ratio))))
    (send self :margin 
          (round (* sidelines text-size))
          (round (* nlines-top text-size)) 
          (round (* sidelines text-size))
          (round (* nlines-bot text-size)))
    ))

(defmeth logo-proto :new-shape ()
  (send self :start-buffering)
  (send self :clear)
  (send self :knt 0)
  (send self :count 0)
  (send self :line-data)
  (send self :draw-logo)
  (send self :fill-logo)
  (send self :nlines (send self :num-lines))
  ;(send self :scale-type 'variable)
  (send self :showing t)
  ;(send self :nclicks 0)
  (send self :show-text (send self :nclicks))
  (send self :buffer-to-screen)
  )

(defmeth logo-proto :simple-write ()
  (let* ((text-size (+ 1 (send self :text-ascent) (send self :text-descent)))
         (next-line (list 0 text-size))
         (origin (+ (send self :real-to-canvas 15 15.5) (* 2 next-line)))
         (center (first origin))
         (textline1 (+ (second origin) 0));5
         (textline2 (+ textline1 text-size))
         (origin-below (send self :real-to-canvas 15 -1))
         (textline3 (- (second origin-below) 5))
         (textline4 (+ textline3 text-size))
         (textline5 (+ textline4 text-size))
         (dc (send self :draw-color))
         (bc (send self :back-color))
         (msg-num (send self :message-number))
         (lines)
         ) 
    (send self :simple-write-flag t)
    (send self :draw-color (send self :draw-color-default))
    (send self :back-color (send self :back-color-default))
    (setf lines (send self :get-text msg-num))
    (send self :buffer lines)
   
    (mapcar #'(lambda (line line-num textline)
                (when line
                      (send self :write-text line center textline 1 1 line-num)))
            lines (iseq 5) (list textline1 textline2 textline3 textline4 textline5))

    (send self :draw-color dc)
    (send self :back-color bc)
    t))

(setf *slogan* "Have Fun Seeing What Your Data Seem To Say,")

(defmeth logo-proto :text (msg-num) 
  (if (numberp msg-num)
      (send self :get-text msg-num)))

(defmeth logo-proto :get-text (msg-num)  
  (case msg-num
    (nil (list "           "  "           "  "           "  
               "           "  "           " ))

    (0 (list " " " "
             *vista-name* 
             *copyright-string*
             (strcat *version-string* " (" (format nil "~a" *run-number*) ")")
             " "
             *vista-website*
             *vista-news*
             *vista-email*))
    
    (1 (list    
        (strcat "         " *vista-name* )
        "                   Forrest W. Young"
        " "   " " 
        (strcat "     " *copyright-string*)
        (strcat "       " *version-string*)
        " "   " "    
        (strcat "              " *vista-website*)
        (strcat "            " *vista-email*)
        (strcat "              "  *vista-news*)
        "________________________________________________________"
        " Next: Left-Click   Back: Right-Click   Exit: Ctrl-Click"
        ))

    (2 (copyrights))
    
    (3 (list "Acknowledgements"
             " "
             "Over the last 10 years, ViSta has evolved from a"
             "testbed for the design of a highly interactive,"
             "very dynamic statistical visualization system, to"
             "just such a system."
             " "
             "As the creator, designer and primary implementor of"
             "ViSta, I am deeply indebted to many, many people who"
             "have contributed in one way or another over the years."
             "Without them, ViSta would not exist."))
    (4 (list "Acknowledgements"
             " "
             "My deepest thanks and appreciation go to my wife"
             "Patricia Young. During the last decade she has stood"
             "watch while I wandered in the developer's cave,"
             "evolving ViSta from what I could see on the screen"
             "to what I could see in my mind's eye."
             " "
             "Patty's patience, understanding, forebearance, support,"
             "and steady love, have been crucial to the realization"
             "of my dreams. Her artistic talent, abilities and spirit"
             "have shaped those dreams, and have had a deep impact"
             "on ViSta's design."))

    (5 (list "Acknowledgements"
             " "
             "I deeply appreciate Norman Cliff's influences on me."
             "As my mentor throughout graduate school, and as the"
             "chairman of my dissertation committee, Norm had a"
             "clear and major influence on my career's beginnings."
             " "
             "But of even more importance, Norm's appreciaton of the"
             "simple approach, his gentle strength, quiet certitude,"
             "civility and his strong sense of the ethical, have had"
             "a continuing impact throughout my entire career."
             " "
             "Thanks Norm. You have been a great role model."))

    (6 (list "Acknowledgements"
             " "
             "Mucho Gracias to Pedro Valero-Mora for his time,"
             "energy, enthusiasm and, last but not least, his code."
             " "
             "Pedro wrote the code for  missing data features,"
             "including visual transformation and imputation methods;"
             "as well as the visually-based Box-Cox and Folded Power"
             "transformations. His newest contribution, the log-linear"
             "plugin, appears in this release for the first time."
             " "
             "Thanks for everything you've done, Pedro." 
             "I expect exciting new developments to come."))

    (7 (list  "Acknowledgements"
              " "
              "I greatly appreciate Dominic Moore's friendship,"
              "and support. His encouragement, criticisms, cheers,"
              "enthusiasm, pep-talks, humor, luniness, food, music" 
              "and incredible speakers are food for my soul."))
    
    (8 (list  "Acknowledgements"
              " "
              "Thanks and much appreciation to Luke Tierney for "
              "creating and providing the XLisp-Stat statistical"                                           "development system, which is the foundation on which"
              "ViSta is built. And thanks to the many folks who"
              "have built the XLisp system on which XLisp-Stat was"
              "itself built: Open Software at its best."
              " "
              "And thanks to Sandy Weisberg who's timely and insightful"
              "suggestions on getting ViSta out the door have helped,"
              "though perhaps not as much as everyone hoped!"))

    (9 (list  "Acknowledgements"
              " "
              "David Lubinsky and John B. Smith made very"
              "fundamental contributions to WorkMap architecture"
              "Without their seminal input there'd be no ViSta."
              " "
              "Richard Faldowski and Carla Bann contributed"
              "fundamentally to SpreadPlot architecture, and"
              "spent many intense months implementing their ideas."))

    (10 (list  "Acknowledgements"
              " "
              "\"Merci Beaucoup\" to Louis Le Guelte for the French"
              "translation."
              " "
              "and"
              " "
              "\"Mucho Gracias\" to Maria R. Rodrigo, Gabriel Molina"
              "and Pedro Valero for the Spanish translation."))

    

    (11 (list  "Acknowledgements"
               " "
               "Bibb Latane, of Social Science Conferences, Inc."
               "funded development of the Excel-ViSta connection,"
               "of multipane windows, and the developer's conference."
               " "
               "Angell Beza, Associate Director of UNC's Odum Institute"
               "for Research in the Social Sciences, was instrumental"
               "in obtaining the SSCI funds."
               " "
               "Jose Sandoval, also at UNC's Odum Institute, developed"
               "the first public courses for teaching about using ViSta."))

    (12 (list  "Acknowledgements"
              " "
              "Doug Kent, funded by UNC's Office of Information"
              "Technology, implemented Version 5's MS-Windows features."
              "  "
              "Jenny Williams of UNC's Office of Information Technology,"
              "was my NT-Guru, especially on the network installation."))

    (13 (list  "Acknowledgements"
              " "
              "Mosaic Plots and Bar Charts are based on an algorithm" 
              "by Ernest Kwan. Frequency Polygons and Histograms"
              "based on algorithms by Jan de Leeuw and Jason Bond."
              " "
              "Many of the Model Objects were written by "
              "Carla Bann, Rich Faldowski, David Flora, Ernest Kwan,"
              "Lee Bee Leng, Mary McFarland and Chris Weisen."))

    (14 (list  "Acknowledgements"
              " "
              
              "The C-to-Lisp Parser used in ViVa was written and" 
              "copyrighted by Erann Gat, who reserves all rights."
              "Used under the terms of the GNU General Public License"
              " "
              "The developer's menu derives from Kjetil Halvorsen,"
              "the Symbol Editor Dialog was implemented by Frederic"
              "Udina, and the BitMap Editor by Fabian Camacho"
              "  "
              "Code for earlier versions was modified"
              "for Unix by Anthony J. Rossini, Charles Kurak," 
              "Albrecht Gebhardt and Andrew V. Klein"
              ))

    (15 (list  "Acknowledgements"
              " " 
               "Quality assurance provided, unwittingly, by  my"
               "undergraduate students, who suffered through"
               "\"creaping-featuritis\" and old documentation."))

    (16 (list  "Acknowledgements"
               " " 
               " " 
               "Thanks to all of you for helping me make"
               "ViSta what it is today."
               " "
               "Without you, it would not exist."
               " "
               "Forrest"))

    (100 (list *vista-name* *slogan* *copyright-string* 
               (strcat *version-string* " (" (format nil "~a" *run-number*) ")") 
             "Please Wait for ViSta to Startup"))
    (101 (list nil nil nil "ERROR: Click to see Listeners" nil))
    (102 (list *vista-name* *slogan* nil "Click to Stop Screen Saver" nil))
    ))

(defmeth logo-proto :show-text (&optional message-number)
    (send self :message-number message-number)
    (send self :simple-write)
    (send self :redraw)
    )

(defmeth logo-proto :comment (text)
  (send self :comment-text text)
  (send self :redraw))



;;;;;;;;;;;;;;
;SPLASH SCREEN
;;;;;;;;;;;;;;

(defun zoom-away ()(splash :pause 60 :copyright nil))

(defun splash (&key (pause 20) (free t) (copyright t) 
                    (message-number 100)
                    (draw-color 'yellow) (back-color 'black))
  (let ((logo (start-splash-screen :message-number message-number 
                                   :draw-color draw-color :back-color back-color)))
    (pause pause)
    (when (or *show-flying-logo* *show-flying-exit-logo*)
          (send logo :fade-splash-screen))
    (send logo :dynamic nil)
    (when copyright (send logo :copyright)
          ;(pause pause)
          )
    (send logo :clear-splash-screen)
    (send logo :remove))) 



(defmeth logo-proto :splash-screen-idle ()
  (let* ((start (send self :idle-start-time))
         (now (get-internal-real-time)) 
         (elapsed))
    (cond 
      (start
       (setf elapsed (- now start))
       (when (> elapsed 60);60 
             (send self :idle-on nil)
             (cond (*pro-version*
                    (send self :fix-it-dialog)
                    (maxmainwindow) (send self :remove)(show-vista))
               (*verbose* (verbose nil)
                (one-button-dialog (format nil "StartUp Error. Send file:~%~aerror~a.log~% to forrest@unc.edu" *default-path* (1- *log-number*)))
                (exit))
               (t (debug) (verbose t) (write-prefload-file)(system (strcat *default-path* "vista.exe")) (exit)))))
      (t (send self :idle-start-time (get-internal-real-time))))))



(defun disolve-splash-screen (L &optional (remove t))
  (send L :fade-splash-screen)
  (send L :dynamic nil)
  (send L :clear-splash-screen)
  (when remove (send L :remove))
  )

(defun fade-splash-screen (L)
  (send L :fade-splash-screen))

(defmeth logo-proto :fade-splash-screen ()
  (defmeth self :do-idle ())
  (send self :transf nil)
  (send self :ready t)
  (send self :idle-on t)
  (send self :dynamic t)
  (send self :glide 1.5 1 2 (1- (mod *run-number* 3)) ; 2 1 2 1
        nil :close nil)
  (defmeth logo-proto :redraw ())
  (send self :showing nil)
  (send self :idle-on nil)
  (send self :showable nil)
  (send self :buffer nil)
  (send self :clear) 
  (send self :redraw)
  t)

(defun clear-splash-screen (L)
  (send L :clear-splash-screen))

(defmeth logo-proto :clear-splash-screen ()
  (send self :transf nil)
  (send self :showing nil)
  (send self :idle-on nil)
  (send self :showable nil)
  (send self :buffer nil)  
  (send self :clear) 
  (send self :redraw)
  )

(defun write-to-logo (text) 
  (send *logo* :write-to-logo text))

(defmeth logo-proto :write-to-logo (text)
  (send self :start-buffering)
  (send self :loading-files t)
  (send self :write-text text)
  (send self :add-text 11 1)
  (send self :buffer-to-screen))



#|___________________________________________________
 |
 | following functions moved to scrnsavr.lsp to be
 | part of new screen-saver inherting from logo
 | fwy oct 2000
 |___________________________________________________
 |
 |
;;;;;;;;;;;;;
;SCREEN SAVER
;;;;;;;;;;;;;

(defun show-screen-saver ()
  (send *vista* :screen-saver-on t)
  (send *workmap* :reset-screen-saver)
  (screen-saver))

(defun screen-saver (&key (show t))
  (let* ((full (send *vista* :screen-saver-full-screen))
         (size (if full (+ '(20 50) (send *desktop-container* :size))
                   (list (first (send *vista* :desktop-size))
                         (second (send *vista* :datasheet-sizes)))))
         (location (if full '(-10 -30)
                       (send *vista* :datasheet-location))))    
    (unless *screen-saver*
            (setf *screen-saver* 
                  (make-logo  :show nil :size size :location location
                              :back-color 'black :draw-color 'yellow
                              :container *desktop-container* :free nil
                              :message-number 99 :gliding nil)))
(print (list "screen-saver" *screen-saver*))
    (apply #'send *screen-saver* :size (- size '(12 0)))
    (apply #'send *screen-saver* :location location)
    (let* ((n (send *screen-saver* :num-lines))
           (u (* 1000 (uniform-rand n))))
      (send *screen-saver* :linestart-coordinate 3 (iseq n) u))
    (send *screen-saver* :screen-saver t)
    (send *screen-saver* :showing nil)
    (send *screen-saver* :transf nil)
    #+macintosh(defmeth *screen-saver* :do-motion (x y)
                 (send self :do-key "a" nil nil))
    (defmeth *screen-saver* :do-key (char m1 m2)
      (send *workmap* :remove-screen-saver)
      #+container(send *desktop-container* :resize)
      )
    (send *screen-saver* :idle-on t)
    (send *screen-saver* :nclicks 20)
    (send *screen-saver* :message-number 99)
    (send *screen-saver* :glide 15 1 1 -1 t)
    (send *screen-saver* :showable t)
    (send *screen-saver* :idle-on t)
    (send *screen-saver* :do-idle)
    *screen-saver*))
|#

;note, the following incorrectly matched block comment symbols
;are as they were found to be by fwy oct 2000... no clue...
;apparently they remove fake-datasheet and start-splash-screen
;from here and leave simple-write active. 
;note that start-splash-screen also appears at top of file
;(i think all this code is no longer used). fwy oct 2000

#|

(defun fake-datasheet ()
  (let* ((size (list (first (send *vista* :desktop-size))
                     (second (send *vista* :datasheet-sizes))))
         (location (list 10 10)))
    (setf *fake-datasheet*
          (make-logo :show nil :size size :location location
                     :message-number (if *show-flying-logo* 20 21) :gliding nil))
    (send *fake-datasheet* :dynamic-fake-datasheet)))
#|

(defun start-splash-screen (&key (free t) (draw-color 'black) (back-color 'white))  
(print "Hi from Last sss in logoobj2")
  (let* ((w (make-logo :copyright-at-top t :free free :local-menus t 
               :draw-color draw-color :back-color back-color
               :size (list 440 220)
               :type 0 :pop-out t :message-number 0)))
    (send w :screen-saver t)
    (send w :showing nil)
    (mapcar #'(lambda (dim)
                (send w :scale dim (* .5 (send w :scale dim))))
            (iseq 4))
    (send w :show-window)
    (send w :show-text)
    (defmeth w :do-idle () (send w :splash-screen-idle))
    (send w :idle-on t)
    (cond 
      (*show-flying-logo* 
       (send w :animate-margins))
      (t (send w :margin 0 20 0 30)
         (send w :simple-write)))
    (send w :front-window)
    (send w :top-most t)
    (send w :ready t)
    w))
|#
(defmeth logo-proto :simple-write ()
"Args: None
Write two lines above and 3 below logo. Only positioned correctly for default window size. Use the write method for a more robust method."
  (let* ((text-size (+ 1 (send self :text-ascent) (send self :text-descent)))
         (next-line (list 0 text-size))
         (origin (+ (send self :real-to-canvas 15 15.5) (* 2 next-line)))
         (center (first origin))
         (textline1 (+ (second origin) 0));5
         (textline2 (+ textline1 text-size))
         (origin-below (send self :real-to-canvas 15 -1))
         (textline3 (- (second origin-below) 5))
         (textline4 (+ textline3 text-size))
         (textline5 (+ textline4 text-size))
         (dc (send self :draw-color))
         (bc (send self :back-color))
         (vistatext  "ViSta: The Visual Statistics System")
         (fwytext "Created, Designed and Implemented by Forrest W. Young")
         (funtext "Have Fun Seeing What Your Data Seem to Say!")
         (comment (send self :comment-text))
         (version (format nil "ViSta ~d (~d.~d.~d.~d)"
                          *VISTA-RELEASE-NUMBER* *log-number*
                          *load-number* *build-number* *run-number*))
         ) 
    (send self :draw-color (send self :draw-color-default))
    (send self :back-color (send self :back-color-default))
    (unless comment 
	(setf comment "Copyright (c) 1992-2000 by Forrest W. Young"))
    (send self :simple-write-flag t)
    (send self :draw-color (send self :draw-color-default))
    (send self :write-text vistatext center textline1 1 1 1)
    (send self :write-text funtext  center textline2 1 1 2)
   ; (send self :write-text *copyright-string* center textline2 1 1 2)
    (if *pro-version*
        (send self :write-text (strcat "Click Here To See Listener If Load Fails")
              center textline3 1 1 3)
        (send self :write-text *vista-website* center textline3 1 1 3))
    (send self :write-text comment center textline4 1 1 4)
    (send self :write-text version center textline5 1 1 5)
    (send self :draw-color dc)
    (send self :back-color bc)
    ))
|#